﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AZVIC.Ei8htPOS.WebUI.Admin.Promotion.PromoCode
{
    public partial class PromoCodeList : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            WebSession.RedirectToAdminDashBoard(false);

            if (!IsPostBack)
            {
                BindPromoCodeList(string.Empty);
            }
        }

        private void BindPromoCodeList(string searchWord)
        {
            List<PromoCodes> pbList = PromoCodesBL.GetList(Guid.Empty, string.Empty, searchWord);
            pbList = (from pb in pbList
                      where pb.IsActive
                      orderby pb.PromoCode ascending
                      select pb).ToList<PromoCodes>();
            grdPromoCode.DataSource = pbList;//.OrderBy(reg => reg.SequenceNo);
            grdPromoCode.DataBind();

            if (pbList.Count == 0)
                WebUtilities.ShowMessage(this, "No Promo Code found");
        }

        protected void btnExportToExcel(object sender, EventArgs e)
        {
            BindPromoCodeList(string.Empty);
            Master.ExportToExcel<Entities.PromoCodes>(grdPromoCode, "PromoCodes");
        }

        protected void grdPromoCode_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            grdPromoCode.PageIndex = e.NewPageIndex;
            BindPromoCodeList(txtSearch.Text.Trim());
        }

        protected void btnSearch_Click(object sender, EventArgs e)
        {
            if (txtSearch.Text.Trim().Length == 0)
            {
                WebUtilities.ShowMessage(this, "Please enter the search word");
                return;
            }
            BindPromoCodeList(txtSearch.Text.Trim());
        }

        protected void btnShowAll_Click(object sender, EventArgs e)
        {
            BindPromoCodeList(string.Empty);
        }
    }
}